package nemosofts.voxradio.utils.helper;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

import androidx.nemosofts.BuildConfig;

import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.item.ItemAbout;
import nemosofts.voxradio.utils.ApplicationUtil;
import nemosofts.voxradio.utils.Encrypted;


public class DBHelper extends SQLiteOpenHelper {

    private static final String TAG = "DBHelper";
    private static final int DATABASE_VERSION = 1;
    private static final String DATABASE_NAME = BuildConfig.APPLICATION_ID + "_" + "app.db";
    private final SQLiteDatabase db;
    Encrypted encryptData;
    final Context context;

    private static final String TABLE_ABOUT = "about";
    private static final String TABLE_RECENT = "recent";

    private static final String TAG_ID = "id";
    private static final String TAG_RADIO_ID = "radio_id";

    private static final String TAG_ABOUT_EMAIL = "email";
    private static final String TAG_ABOUT_AUTHOR = "author";
    private static final String TAG_ABOUT_CONTACT = "contact";
    private static final String TAG_ABOUT_WEBSITE = "website";
    private static final String TAG_ABOUT_DESC = "description";
    private static final String TAG_ABOUT_DEVELOPED = "developed";
    private static final String TAG_ABOUT_ENVATO_API_KEY = "envato_key";
    private static final String TAG_ABOUT_MORE_APP = "more_apps";

    private final String[] columnsAbout = new String[]{
            TAG_ABOUT_EMAIL, TAG_ABOUT_AUTHOR, TAG_ABOUT_CONTACT, TAG_ABOUT_WEBSITE, TAG_ABOUT_DESC,
            TAG_ABOUT_DEVELOPED, TAG_ABOUT_ENVATO_API_KEY, TAG_ABOUT_MORE_APP
    };

    private final String[] columnsRecent = new String[]{
            TAG_ID,
            TAG_RADIO_ID
    };

    private static final String CREATE_TABLE = "CREATE TABLE ";
    private static final String AUTOINCREMENT = " INTEGER PRIMARY KEY AUTOINCREMENT, ";
    private static final String TEXT_ONE = " TEXT,";
    private static final String TEXT_END = " TEXT";

    // Creating table query
    private static final String CREATE_TABLE_RECENT = CREATE_TABLE + TABLE_RECENT + "("
            + TAG_ID + AUTOINCREMENT
            + TAG_RADIO_ID + TEXT_END
            + ")";

    // Creating table about
    private static final String CREATE_TABLE_ABOUT = CREATE_TABLE + TABLE_ABOUT + " ("
            + TAG_ABOUT_EMAIL + TEXT_ONE
            + TAG_ABOUT_AUTHOR + TEXT_ONE
            + TAG_ABOUT_CONTACT + TEXT_ONE
            + TAG_ABOUT_WEBSITE + TEXT_ONE
            + TAG_ABOUT_DESC + TEXT_ONE
            + TAG_ABOUT_DEVELOPED + TEXT_ONE
            + TAG_ABOUT_ENVATO_API_KEY + TEXT_ONE
            + TAG_ABOUT_MORE_APP + TEXT_END
            + ")";

    public DBHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
        encryptData = new Encrypted(context);
        this.context = context;
        db = getWritableDatabase();
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        try {
            db.execSQL(CREATE_TABLE_ABOUT);
            db.execSQL(CREATE_TABLE_RECENT);
        } catch (Exception e) {
            ApplicationUtil.log(TAG, "Error creating table", e);
        }
    }

    // Upgrade -------------------------------------------------------------------------------------
    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (db == null){
            return;
        }
        final String dropTable = "DROP TABLE IF EXISTS ";
        db.execSQL(dropTable + TABLE_RECENT);
        db.execSQL(dropTable + TABLE_ABOUT);
        onCreate(db);
    }

    @SuppressLint("Range")
    public void addToRecent(String id) {
        try (Cursor cursor = db.query(TABLE_RECENT, columnsRecent, null, null,
                null, null, null)) {
            if (cursor.getCount() > 20) {
                cursor.moveToFirst();
                String oldestId = cursor.getString(cursor.getColumnIndex(TAG_RADIO_ID));
                db.delete(TABLE_RECENT, TAG_RADIO_ID + "=?", new String[]{oldestId});
            }
        }

        if (checkRecent(id)) {
            db.delete(TABLE_RECENT, TAG_RADIO_ID + "=" + id, null);
        }

        ContentValues contentValues = new ContentValues();
        contentValues.put(TAG_RADIO_ID, id);
        db.insert(TABLE_RECENT, null, contentValues);
    }

    private boolean checkRecent(String id) {
        try (Cursor cursor = db.query(TABLE_RECENT, columnsRecent, TAG_RADIO_ID + "=?",
                new String[]{id}, null, null, null)) {
            return cursor.getCount() > 0;
        }
    }

    @SuppressLint("Range")
    public String getRecentIDs(String limit) {
        StringBuilder radioIDs = new StringBuilder();
        try (Cursor cursor = db.query(TABLE_RECENT, new String[]{TAG_RADIO_ID}, null,
                null, null, null, TAG_ID + " DESC", limit)) {
            if (cursor.moveToFirst()) {
                do {
                    if (radioIDs.length() > 0) {
                        radioIDs.append(",");
                    }
                    radioIDs.append(cursor.getString(cursor.getColumnIndex(TAG_RADIO_ID)));
                } while (cursor.moveToNext());
            }
        }
        return radioIDs.toString();
    }

    // About ---------------------------------------------------------------------------------------
    public void addToAbout() {
        try {
            db.delete(TABLE_ABOUT, null, null);

            ContentValues contentValues = new ContentValues();
            contentValues.put(TAG_ABOUT_EMAIL, Callback.getItemAbout().email());
            contentValues.put(TAG_ABOUT_AUTHOR, Callback.getItemAbout().author());
            contentValues.put(TAG_ABOUT_CONTACT, Callback.getItemAbout().contact());
            contentValues.put(TAG_ABOUT_WEBSITE, Callback.getItemAbout().website());
            contentValues.put(TAG_ABOUT_DESC, Callback.getItemAbout().description());
            contentValues.put(TAG_ABOUT_DEVELOPED, Callback.getItemAbout().developedBy());
            contentValues.put(TAG_ABOUT_ENVATO_API_KEY, "");
            db.insert(TABLE_ABOUT, null, contentValues);
        } catch (Exception e) {
            Log.e(TAG, "Error add to about", e);
        }
    }

    @SuppressLint("Range")
    public void getAbout() {
        try (Cursor c = db.query(TABLE_ABOUT, columnsAbout, null, null,
                null, null, null)) {
            if (c.moveToFirst()) {
                String email = c.getString(c.getColumnIndex(TAG_ABOUT_EMAIL));
                String author = c.getString(c.getColumnIndex(TAG_ABOUT_AUTHOR));
                String contact = c.getString(c.getColumnIndex(TAG_ABOUT_CONTACT));
                String website = c.getString(c.getColumnIndex(TAG_ABOUT_WEBSITE));
                String desc = c.getString(c.getColumnIndex(TAG_ABOUT_DESC));
                String developed = c.getString(c.getColumnIndex(TAG_ABOUT_DEVELOPED));
                String moreApps = c.getString(c.getColumnIndex(TAG_ABOUT_MORE_APP));

                Callback.setItemAbout(new ItemAbout(email, author, contact, website, desc, developed, moreApps));
            }
        }
    }

    @Override
    public synchronized void close () {
        if (db != null && db.isOpen()) {
            db.close();
            super.close();
        }
    }
}
